#include <QtGui>

class TextEdit : public QTextEdit
{
	Q_OBJECT

	public:
		TextEdit(QWidget* parent = 0);
		TextEdit(QCompleter* completer, QWidget* parent = 0);
		virtual ~TextEdit();

	public:
		//void SetCompleter(QCompleter* completer);
		void SetTableCompleter(QCompleter* tableCompleter);
		void ProcessCompletion(QKeyEvent *e);

	public slots:
		void InsertCompletion(const QString& completion);
		QAbstractItemModel* ModelFromFile(const QString& fileName);
		void SetModel(QAbstractItemModel* model);

	protected:
		void keyPressEvent(QKeyEvent *e);
		void focusInEvent(QFocusEvent *e);
		void keyReleaseEvent(QKeyEvent *e);

	public:
		QCompleter* GetCompleter() const;
		QCompleter* GetTableCompleter() const;

	private:
		QCompleter* completer;
		QCompleter* tableCompleter;
		QAbstractItemModel* model;
		QAbstractItemModel* tableModel;
		bool mode; // 0:Ϲ Completer 1:̺  Completer
		bool changeModel;

protected:
	//ContextMenuEvent
	virtual void contextMenuEvent( QContextMenuEvent *);

};

inline QCompleter* TextEdit::GetCompleter() const
{
	return this->completer;
}

inline QCompleter* TextEdit::GetTableCompleter() const
{
	return this->tableCompleter;
}

